IF NOT EXISTS
(
    SELECT 1
    FROM INFORMATION_SCHEMA.TABLES
    WHERE TABLE_NAME = N'EST_PED_ELTR_AUDIT'
)
    BEGIN
		CREATE TABLE [dbo].[EST_PED_ELTR_AUDIT]
		([CD_USU]        [INT] NOT NULL,
		 [DT_CAD]        [DATETIME] NOT NULL,
		 [JUSTIFICATIVA] [VARCHAR](255) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
		 [QUANTIDADE]    [MONEY] NOT NULL,
		 [CD_PROD]       [INT] NOT NULL,
		 [CD_FILIAL]     [INT] NOT NULL,
		 [CD_PED_SOL]    [INT] NOT NULL,
		 CONSTRAINT [PK_EST_PED_ELTR_AUDIT] PRIMARY KEY CLUSTERED([CD_PED_SOL] ASC, [CD_FILIAL] ASC, [CD_PROD] ASC, [DT_CAD] ASC)
		 WITH(PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
		)
        ON [PRIMARY];
    END;